<?php

    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: POST, GET");
    header("Access-Control-Allow-Headers: Content-Type");
    header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);
    
    if(isset($data)){
        
        include('../database.php');
        $user = $data['user'];
        
        $sql = "SELECT * FROM clients WHERE user_id='$user' ";
        $res = mysqli_query($db,$sql);
        $count = mysqli_num_rows($res);
        
        if($count > 0 ){
            
            $raw_data = [
                "status" => "success",
                "code" => "0000",
                "totalclients" => $count,
                "data" => []
            ];
            
            while($rows = mysqli_fetch_assoc($res)){
                $raw_data['data'][] = [
                    "clientId" => $rows['id'],
                    "clientName" => $rows['client_name'],
                    "clientPhone" => $rows['client_phone'],
                    "clientLocation" => $rows['client_location']
                ];
            }
            
        }else{
            $raw_data = [
                "status" => "error",
                "code" => "0001",
                "totalclients" => $count
            ];
        }
        
        echo json_encode($raw_data);
        
    }else{
        echo json_encode([
            'status' => 'error',
            'code' => '0002',
            'error' => [
                'message'=>'invalid post data'
            ]
        ]);
    }
    
    
    
}else{
    echo json_encode([
        'status' => 'error',
        'code' => '0003',
        'error' => [
            'message'=>'invalid request method'
        ]
    ]);
}